/* Copyright (C) 2023 MacroSilicon Technology Co., Ltd.
 *
 * This software is licensed under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation, and
 * may be copied, distributed, and modified under those terms.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * usb_hal_edid.h -- Drm driver for MacroSilicon chip 913x and 912x
 */

#ifndef __USB_HAL_EDID_H__
#define __USB_HAL_EDID_H__



typedef enum _E_BS7160_SYNC_POLARITY_
{
    _ProgVNegHNeg       = 0x1,
    _ProgVNegHPos       = 0x3,
    _ProgVPosHNeg       = 0x5,
    _ProgVPosHPos       = 0x7,

    _InterVNegHNeg       = 0x0,
    _InterVNegHPos       = 0x2,
    _InterVPosHNeg       = 0x4,
    _InterVPosHPos       = 0x6
} _SYNC_POLARITY_E;

typedef enum _E_BS7160_VIDEO_FORMAT_
{
	_VFMT_CEA_NULL = 0,
	_VFMT_CEA_01_640x480P_60HZ = 1,
	_VFMT_CEA_02_720x480P_60HZ = 2,
	_VFMT_CEA_03_720x480P_60HZ = 3,
	_VFMT_CEA_04_1280x720P_60HZ = 4,
	_VFMT_CEA_05_1920x1080I_60HZ = 5,
	_VFMT_CEA_06_720x480I_60HZ = 6,
	_VFMT_CEA_07_720x480I_60HZ = 7,
	_VFMT_CEA_08_720x240P_60HZ = 8,
	_VFMT_CEA_09_720x240P_60HZ = 9,
	_VFMT_CEA_10_720x480I_60HZ = 10,
	_VFMT_CEA_11_720x480I_60HZ = 11,
	_VFMT_CEA_12_720x240P_60HZ = 12,
	_VFMT_CEA_13_720x240P_60HZ = 13,
	_VFMT_CEA_14_1440x480P_60HZ = 14,
	_VFMT_CEA_15_1440x480P_60HZ = 15,
	_VFMT_CEA_16_1920x1080P_60HZ = 16,
	_VFMT_CEA_17_720x576P_50HZ = 17,
	_VFMT_CEA_18_720x576P_50HZ = 18,
	_VFMT_CEA_19_1280x720P_50HZ = 19,
	_VFMT_CEA_20_1920x1080I_50HZ = 20,
	_VFMT_CEA_21_720x576I_50HZ = 21,
	_VFMT_CEA_22_720x576I_50HZ = 22,
	_VFMT_CEA_23_720x288P_50HZ = 23,
	_VFMT_CEA_24_720x288P_50HZ = 24,
	_VFMT_CEA_25_720x576I_50HZ = 25,
	_VFMT_CEA_26_720x576I_50HZ = 26,
	_VFMT_CEA_27_720x288P_50HZ = 27,
	_VFMT_CEA_28_720x288P_50HZ = 28,
	_VFMT_CEA_29_1440x576P_50HZ = 29,
	_VFMT_CEA_30_1440x576P_50HZ = 30,
	_VFMT_CEA_31_1920x1080P_50HZ = 31,
	_VFMT_CEA_32_1920x1080P_24HZ = 32,
	_VFMT_CEA_33_1920x1080P_25HZ = 33,
	_VFMT_CEA_34_1920x1080P_30HZ = 34,
	_VFMT_CEA_35_2880x480P_60HZ = 35,
	_VFMT_CEA_36_2880x480P_60HZ = 36,
	_VFMT_CEA_37_2880x576P_50HZ = 37,
	_VFMT_CEA_38_2880x576P_50HZ = 38,
	_VFMT_CEA_60_1280x720P_24HZ = 60,
	_VFMT_CEA_61_1280x720P_25HZ = 61,
	_VFMT_CEA_62_1280x720P_30HZ = 62,

	//                                    
	_VFMT_VESA_64_640X480_60 = 64,
	_VFMT_VESA_65_640X480_75 = 65,
	_VFMT_VESA_66_800X600_60 = 66,
	_VFMT_VESA_67_800X600_72 = 67,
	_VFMT_VESA_68_800X600_75 = 68,
	_VFMT_VESA_69_800X600_85 = 69,
	_VFMT_VESA_70_800X600_120_RB = 70,
	_VFMT_VESA_71_1024X768_60 = 71,
	_VFMT_VESA_72_1024X768_70 = 72,
	_VFMT_VESA_73_1024X768_75 = 73,
	_VFMT_VESA_74_1024X768_85 = 74,
	_VFMT_VESA_75_1024X768_120_RB = 75,
	_VFMT_VESA_76_1152X864_60 = 76,
	_VFMT_VESA_77_1152X864_75 = 77,
	_VFMT_VESA_78_1280X600_60 = 78,
	_VFMT_VESA_79_1280X720_60_DMT = 79,
	_VFMT_VESA_80_1280X720_60_CVT = 80,
	_VFMT_VESA_81_1280X720_60_CVT_RB = 81,
	_VFMT_VESA_82_1280X720_75_CVT = 82,
	_VFMT_VESA_83_1280X720_85_CVT = 83,
	_VFMT_VESA_84_1280X768_60 = 84,
	_VFMT_VESA_85_1280X768_60_RB = 85,
	_VFMT_VESA_86_1280X768_75 = 86,
	_VFMT_VESA_87_1280X800_60 = 87,
	_VFMT_VESA_88_1280X800_75 = 88,
	_VFMT_VESA_89_1280X800_85 = 89,
	_VFMT_VESA_90_1280X800_120_RB = 90,
	_VFMT_VESA_91_1280X960_60_DMT = 91,
	_VFMT_VESA_92_1280X960_60_CVT = 92,
	_VFMT_VESA_93_1280X960_75_CVT = 93,
	_VFMT_VESA_94_1280X960_85 = 94,
	_VFMT_VESA_95_1280X960_120_RB = 95,
	_VFMT_VESA_96_1280X1024_60 = 96,
	_VFMT_VESA_97_1280X1024_75 = 97,
	_VFMT_VESA_98_1280X1024_85 = 98,
	_VFMT_VESA_99_1280X1024_120_RB = 99,
	_VFMT_VESA_100_1360X768_60 = 100,
	_VFMT_VESA_101_1360X768_120_RB = 101,
	_VFMT_VESA_102_1366X768_60 = 102,
	_VFMT_VESA_103_1400X1050_60 = 103,
	_VFMT_VESA_104_1400X1050_75 = 104,
	_VFMT_VESA_105_1400X1050_85 = 105,
	_VFMT_VESA_106_1400X1050_120_RB = 106,
	_VFMT_VESA_107_1440X900_60_DMT = 107,
	_VFMT_VESA_108_1440X900_75 = 108,
	_VFMT_VESA_109_1440X900_85 = 109,
	_VFMT_VESA_110_1440X900_120_RB = 110,
	_VFMT_VESA_111_1600X900_60_CVT = 111,
	_VFMT_VESA_112_1600X900_60_DMT_RB = 112,
	_VFMT_VESA_113_1600X900_75_CVT = 113,
	_VFMT_VESA_114_1600X900_85_CVT = 114,
	_VFMT_VESA_115_1600X1200_60 = 115,
	_VFMT_VESA_116_1600X1200_70 = 116,
	_VFMT_VESA_117_1600X1200_75 = 117,
	_VFMT_VESA_118_1600X1200_85 = 118,
	_VFMT_VESA_119_1600X1200_120_RB = 119,
	_VFMT_VESA_120_1680X1050_60 = 120,
	_VFMT_VESA_121_1680X1050_60_RB = 121,
	_VFMT_VESA_122_1680X1050_75 = 122,
	_VFMT_VESA_123_1680X1050_85 = 123,
	_VFMT_VESA_124_1680X1050_120_RB = 124,
	_VFMT_VESA_125_1792X1344_60 = 125,
	_VFMT_VESA_126_1792X1344_75 = 126,
	_VFMT_VESA_127_1856X1392_60 = 127,
	_VFMT_VESA_128_1856X1392_75 = 128,
	_VFMT_VESA_129_1920X1080_60_DMT = 129,
	_VFMT_VESA_130_1920X1080_60_CVT = 130,
	_VFMT_VESA_131_1920X1080_60_CVT_RB = 131,
	_VFMT_VESA_132_1920X1200_60_CVT = 132,
	_VFMT_VESA_133_1920X1200_60_DMT_RB = 133,
	_VFMT_VESA_134_1920X1200_75 = 134,
	_VFMT_VESA_135_1920X1200_85 = 135,
	_VFMT_VESA_136_1920X1440_60 = 136,
	_VFMT_VESA_137_1920X1440_75 = 137,
	_VFMT_VESA_138_1920X1440_85_CVT = 138,
	_VFMT_VESA_139_2048X1536_60_CVT = 139,
	_VFMT_VESA_140_2048X1536_75_CVT = 140,
	_VFMT_VESA_141_2048X1536_85_CVT = 141,
	_VFMT_VESA_142_2560X1600_60 = 142,

	_VFMT_INVALID = 0xFF
} _VIDEO_FORMAT_E;

#endif
